/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.collection;

import org.openjdk.jmc.common.collection.EntryHashMap;

public class MapToolkit {
    public static <K> EntryHashMap<K, IntEntry<K>> createIntMap(int initialCapacity, float loadFactor) {
        return new EntryHashMap<K, IntEntry<K>>(initialCapacity, loadFactor){

            @Override
            protected IntEntry<K> computeValue(K key) {
                return new IntEntry(key);
            }
        };
    }

    public static class IntEntry<K>
    extends EntryHashMap.Entry<K>
    implements Comparable<IntEntry<K>> {
        private int value = 0;

        private IntEntry(K key) {
            super(key);
        }

        @Override
        public int compareTo(IntEntry<K> o) {
            return Integer.compare(this.value, o.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntEntry) {
                IntEntry o = (IntEntry)obj;
                return this.getKey().equals(o.getKey()) && this.value == o.value;
            }
            return false;
        }

        public int hashCode() {
            return 17 * this.getKey().hashCode() + this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

